# table {#table}

## Syntax {#syntax}

`table(X, [X1], [X2], ...)`

or

`table(capacity:size, colNames, colTypes)`

## Arguments {#arguments}

For the first scenario: **X**, **X1**, **X2** ... can be vectors, matrices or tuples. Each vector, each matrix column and each tuple element must have the same length. **When _Xk_is a tuple:**

-   If the elements of *Xk*are vectors of equal length, each element of the tuple will be treated as a column in the table.
-   If *Xk*contains elements of different types or unequal lengths, it will be treated as a single column in the table \(with the column type set to ANY\), and each element will correspond to the value of that column in each row.

For the second scenario:

-   **capacity** is a positive integer indicating the amount of memory \(in terms of the number of rows\) allocated to the table. When the number of rows exceeds capacity, the system will first allocate memory of 1.2~2 times of capacity, copy the data to the new memory space, and release the original memory. For large tables, these steps may use significant amount of memory.

-   **size** is an integer no less than 0 indicating the initial size \(in terms of the number of rows\) of the table. If *size*=0, create an empty table; If *size*&gt;0, the initialized values are:

    -   false for Boolean type;

    -   0 for numeric, temporal, IPADDR, COMPLEX, and POINT types;

    -   Null value for Literal, INT128 types.

    **Note:** If *colTypes* is an array vector, *size* must be 0.

-   **colNames** is a STRING vector of column names.

-   **colTypes** is a STRING vector of data types. It can use either the reserved words for data types or corresponding strings.


## Details {#details}

-   For the first scenario: Converts vectors/matrices/tuples, or the combination of vectors and tuples into a table.
-   For the second scenario: Creates an empty or initialized table of fixed data types.

## Examples {#examples}

Examples of `table(X, [X1], [X2], …..)`:

```
id=`XOM`GS`AAPL
x=102.1 33.4 73.6
table(id, x);
```

|id|x|
|---|---|
|XOM|102.1|
|GS|33.4|
|AAPL|73.6|

```
table(`XOM`GS`AAPL as id, 102.1 33.4 73.6 as x);
```

|id|x|
|---|---|
|XOM|102.1|
|GS|33.4|
|AAPL|73.6|

In the following example, table t is created from a vector x, a matrix y and a tuple z.

```
x=1..6
y=matrix(11..16, 17..22)
z=(101..106, 201..206)
t=table(x,y,z)
t.rename!(`x`y1`y2`z1`z2);

t;
```

|x|y1|y2|z1|z2|
|---|---|---|---|---|
|1|11|17|101|201|
|2|12|18|102|202|
|3|13|19|103|203|
|4|14|20|104|204|
|5|15|21|105|205|
|6|16|22|106|206|

Convert a matrix into a table:

```
m=matrix(1 2, 3 4, 5 6);
m;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

```
t=table(m).rename!(`a`b`x);
t;
```

|a|b|x|
|---|---|---|
|1|3|5|
|2|4|6|

Tuples with elements of the same type and equal length will be converted into multiple columns \(with each element as a separate column\), while tuples with mixed types or unequal element lengths will be converted into a column of type **ANY**:

``` {#codeblock_ztc_rcn_1fc}
id = 1 2 3
val = [[1,2,3], [4,5,6],[7,8,9]]
metrics = [`A,[2.2 3.2], 3.2]
t = table(id, val, metrics)
```

|**id**|**col1**|**col2**|**col3**|**metrics**|
|------|--------|--------|--------|-----------|
|1|1|4|7|A|
|2|2|5|8|\(\[2.2,3.2\]\)|
|3|3|6|9|3.2|

Examples of `table(capacity:size, colNames, colTypes)`:

```
table(100:5, `name`id`value, [STRING,INT,DOUBLE]);
```

|name|id|value|
|----|---|-----|
||0|0|
||0|0|
||0|0|
||0|0|
||0|0|

```
table(100:5, `name`id`value, `STRING`INT`DOUBLE);
```

|name|id|value|
|----|---|-----|
||0|0|
||0|0|
||0|0|
||0|0|
||0|0|

```
table(100:1, [`value], [DOUBLE]);
```

|value|
|-----|
|0|

