# tTest {#ttest}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`tTest(X, [Y], [mu=0.0], [confLevel=0.95], [equalVar=false])`

## Arguments {#arguments}

**X** is a numeric vector indicating the sample for the t-test.

**Y** \(optional\) is a numeric vector indicating the second sample for a paired-sample t-test.

**mu** \(optional\) is a floating number. If *Y* is not specified, *mu* is the mean value of *X* in the null hypothesis; if *Y* is specified, *mu* is the difference in the mean values of *X* and *Y* in the null hypothesis.The default value is 0.

**confLevel** \(optional\) is a floating number between 0 and 1 indicating the confidence level of the test. The default value is 0.95.

**equalVar** \(optional\) is a Boolean value indicating whether the variance of *X* and *Y* are the same in the null hypothesis. The default value is false.

## Details {#details}

If *Y* is not specified, conduct a one-sample t-test on *X*. If *Y* is specified, conduct a paired-sample t-test on *X* and *Y*.

Return a dictionary with the following keys:

-   stat: a table with p-value and confidence interval under 3 alternative hypotheses.

-   df: degree of freedom

-   confLevel: confidence level

-   method: type of t-test used

-   tValue: t-stat


## Examples {#examples}

One-sample t-test:

```
x = norm(10.0, 1.0, 20)
tTest(x, , 10.0);

/* output:
stat->
alternativeHypothesis        pValue   lowerBound upperBound
---------------------------- -------- ---------- ----------
true mean is not equal to 10 0.499649 9.68582    10.621998
true mean is less than 10    0.750176 -Infinity  10.540616
true mean is greater than 10 0.249824 9.767202   Infinity

df->19
confLevel->0.95
method->One sample t-test
tValue->0.688192
*/
```

Paired-sample t-test with equal sample variance:

```
x = norm(10.0, 1.0, 20)
y = norm(4.0, 1.0, 10)
tTest(x, y, 6.0, , true);

/* output:
stat->
alternativeHypothesis                pValue   lowerBound upperBound
------------------------------------ -------- ---------- ----------
difference of mean is not equal to 6 0.438767 5.539812   7.03262
difference of mean is less than 6    0.780616 -Infinity  6.906078
difference of mean is greater than 6 0.219384 5.666354   Infinity

df->28
confLevel->0.95
method->Two sample t-test
tValue->0.785483
*/
```

Paired-sample t-test with no restriction on sample variance:

```
x = norm(10.0, 1.0, 20)
y = norm(1.0, 2.0, 10)
tTest(x, y, 9.0);

/* output:
stat->
alternativeHypothesis          pValue   lowerBound upperBound
------------------------------ ----------------- ---------- ----------
true difference of mean is n...0.983376 7.752967   10.271656
true difference of mean is l...0.508312 -Infinity  10.04285
true difference of mean is g...0.491688 7.981773   Infinity

df->12.164434
confLevel->0.95
method->Welch two sample t-test
tValue->0.021269
*/
```

