# syncDict {#syncdict}

## Syntax {#syntax}

`syncDict(keyObj, valueObj, [sharedName], [ordered=false])`

or

`syncDict(keyType, valueType, [sharedName], [ordered=false])`

## Arguments {#arguments}

**keyObj** is a vector indicating dictionary keys.

**valueObj** is a vector indicating dictionary values.

**keyType** is the data type of dictionary keys. The following data categories are supported: Integral \(excluding COMPRESSED\), Temporal, Floating and Literal.

**valueType** is the data type of dictionary values. Note that COMPLEX/POINT/DECIMAL is not supported.

**sharedName** \(optional\) is a string. If it is specified, the dictionary is shared across sessions.

**ordered** \(optional\) is a Boolean value. The default value is false, which indicates to create a regular dictionary. True means to create an ordered dictionary. The regular dictionaries do not track the insertion order of the key-value pairs whereas the ordered dictionaries preserve the insertion order of key-value pairs.

## Details {#details}

Return a thread-safe dictionary that allows concurrent read and write by multiple threads.

## Examples {#examples}

Example 1:

```
x=1 2 3
y=4.5 7.8 4.3
z=syncDict(x,y);
/* output:
3->4.3
1->4.5
2->7.8
*/

z=syncDict(INT,DOUBLE)
z[5]=7.9
z;
// output: 5->7.9

syncDict(INT,DOUBLE, `sn)
sn[5 6]=10.99 2.33
sn[5];
// output: 10.99

// y is a vector of DECIMAL32 type. Create a dictionary z with y as values.
x=1 3 2
y = decimal32\(1.23 3 3.14, 3\)
z=dict\(x,y,true\);
z;
/\* output:
1-&gt;1.230
3-&gt;3.000
2-&gt;3.140
\*/
```

In the following example, concurrent write to dictionary z1 results in server crash.

```
def task1(mutable d,n){
    for(i in 0..n){
        d[i]=i*2
    }
}

def task2(mutable d,n){
    for(i in 0..n){
        d[i]=i+1
    }
}
n=10000000

z1=dict(INT,INT)
jobId1=submitJob("task1",,task1,z1,n)
jobId2=submitJob("task2",,task2,z1,n);
```

In comparison, concurrent write to the thread-safe dictionary z2 is allowed.

```
z2=syncDict(INT,INT)
jobId3=submitJob("task1",,task1,z2,n)
jobId4=submitJob("task2",,task2,z2,n)
getJobReturn(jobId3, true)
getJobReturn(jobId4, true)
z2;
```

Related: [array](../a/array.md), [matrix](../m/matrix.md), [dictUpdate!](../d/dictUpdate!.md), [dict](../d/dict.md)

Example 2: usage of syncDict with [go](../../Programming/ProgrammingStatements/go.md):

``` {#codeblock_nzv_yw3_5dc}
syncDict(SYMBOL,RESOURCE,`resDict)
go
resDict[`a]=10
```

