# sum2 {#sum2}

## Syntax {#syntax}

`sum2(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

If *X* is a vector, return the sum of squares of all the elements in *X*.

If *X* is a matrix, calculate the sum of squares for each column of *X* and return a vector.

If *X* is a table, calculate the sum of squares for each column of *X* and return a table.

As with all aggregate functions, null values are not included in the calculation.

If all elements of a calculation are null values, the result is NULL.

Please note that the data type of the result is always DOUBLE, even if the data type of *X* is INT or LONG.

## Examples {#examples}

```
sum2(1 2 3);
// output: 14

sum2(1 NULL NULL);
// output: 1

sum2(1.5 4.6 7.8);
// output: 84.25

m=matrix(1 2 3, 4 5 6);
m;
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
sum2(m);
// output: [14,77]
```

