# substru {#substru}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`substru(X, offset, [length])`

## Arguments {#arguments}

**X** is a string scalar/vector.

**offset** is a nonnegative integer.

**length** \(optional\) is a positive integer.

## Details {#details}

The only differerence between `substru` and `substr` is that `substru` can process Unicode strings.

Return a substring of *X* with the specified starting position \(*offset*\) and *length*. The first character of *X* corresponds to position 0. If *length* exceeds the length of *X*, stop at the end of *X*.

If *length* is not specified, return a substring of *X* from the specified starting position \(*offset*\) to the end of *X*.

## Examples {#examples}

```
substru("This is a test", 0, 4);
// output: This

substru("This is a test", 5, 2);
// output: is

substru("This is a test", 5);
// output: is a test

substru("This is a test", 8, 100);
// output: a test
```

