# submitJob {#submitjob}

## Syntax {#syntax}

`submitJob(jobId, jobDesc, jobDef, args...)`

## Arguments {#arguments}

**jobId** is a string indicating the job ID.

**jobDesc** is a string indicating job description.

**jobDef** is a local function that defines the job. Please note that it is not the function name, and therefore it should not be quoted.

**args...** is the arguments of the function. If the function has no arguments, it is unspecified.

## Details {#details}

Submit a batch job to the local node and return the job ID for future reference. To submit a batch job to a remote node, please use submitJob together with [rpc](../r/rpc.md) or [remoteRun](../r/remoteRun.md). For details please refer to the section of [BatchJobManagement](../../Maintenance/BatchJobManagement.md).

## Examples {#examples}

The following script submits a job to the local node:

```
def jobDemo(n){
    s = 0
    for (x in 1 : n) {
        s += sum(sin rand(1.0, 100000000)-0.5)
        print("iteration " + x + " " + s)
    }
    return s
};

submitJob("jobDemo1","job demo", jobDemo, 100);
// output: jobDemo1

getJobStatus("jobDemo1");
```

|node|userID|jobId|rootJobId|jobDesc|priority|parallelism|clientIp|clientPort|receivedTime|startTime|endTime|errorMsg|
|----|------|-----|---------|-------|--------|-----------|--------|----------|------------|---------|-------|--------|
|local8848|guest|jobDemo1|d1d76cad-d46f-338c-4179-21cface3ce7c|job demo|4|2|127.0.0.1|62016|2023.12.12T17:52:01.576|2023.12.12T17:52:01.585| ||

*endTime* is empty. This means the job is still running. After the job finishes, *endTime* will have a value.

```
getJobStatus("jobDemo1");
```

|node|userID|jobId|rootJobId|jobDesc|priority|parallelism|clientIp|clientPort|receivedTime|startTime|endTime|errorMsg|
|----|------|-----|---------|-------|--------|-----------|--------|----------|------------|---------|-------|--------|
|local8848|guest|jobDemo1|d1d76cad-d46f-338c-4179-21cface3ce7c|job demo|4|2|127.0.0.1|62016|2023.12.12T17:52:01.576|2023.12.12T17:52:01.585|2023.12.12T17:53:23.204||

```
getJobMessage("jobDemo1");

/* output:
2020-09-13 13:40:10.139269 Start the job [jobDemo1]: job demo
2020-09-13 13:40:11.159543 iteration 1 3914.672836
2020-09-13 13:40:12.118014 iteration 2 4263.240185
2020-09-13 13:40:13.069435 iteration 3 4006.833021
......
2020-09-13 13:41:41.769256 iteration 97 -1897.963368
2020-09-13 13:41:42.706748 iteration 98 -2455.003061
2020-09-13 13:41:43.640253 iteration 99 924.915703
2020-09-13 13:41:43.640253 The job is done.
*/

getJobReturn("jobDemo1");
// output: 924.915703

submitJob("jobDemo2",, jobDemo, 10);
// output: jobDemo2

getRecentJobs();
```

|node|userID|jobId|rootJobId|jobDesc|priority|parallelism|clientIp|clientPort|receivedTime|startTime|endTime|errorMsg|
|----|------|-----|---------|-------|--------|-----------|--------|----------|------------|---------|-------|--------|
|local8848|guest|jobDemo1|d1d76cad-d46f-338c-4179-21cface3ce7c|job demo|4|2|127.0.0.1|62016|2023.12.12T17:52:01.576|2023.12.12T17:52:01.585|2023.12.12T17:53:23.204||
|local8848|guest|jobDemo2|def84639-5b21-c6b0-47be-986b4563e192|jobDemo|4|2|127.0.0.1|62016|2023.12.12T17:57:42.325|2023.12.12T17:57:42.327|2023.12.12T17:57:49.995||

The following script submits a job to a remote node:

With function `rpc` \("DFS\_NODE2" is located in the same cluster as the local node\):

```
def jobDemo(n){
    s = 0
    for (x in 1 : n) {
        s += sum(sin rand(1.0, 100000000)-0.5)
        print("iteration " + x + " " + s)
    }
    return s
}

rpc("DFS_NODE2", submitJob, "jobDemo3", "job demo", jobDemo, 10);
// output: jobDemo3


rpc("DFS_NODE2", getJobReturn, "jobDemo3");
// output: -3426.577521
```

use function `remoteRun` or `remoteRunWithCompression`. For example:

```
conn = xdb("DFS_NODE2")
conn.remoteRun(submitJob, "jobDemo4", "job demo", jobDemo, 10);
// output: jobDemo4

conn.remoteRun(getJobReturn, "jobDemo4");
// output: 4238.832005
```

