# stringFormat {#stringformat}

## Syntax {#section_db5_qq2_czb .section}

`stringFormat(format, [args...])`

## Arguments {#section_sj3_rq2_czb .section}

**format** is a string containing zero or more placeholders.

**args...** \(optional\) is one or more values to fill in the placeholder\(s\) in *format*. If specified, the number and data type of *args* must be consistent with the number and data types of the placeholders in *format*; if not specified, the function outputs *format* directly.

## Details {#section_d1b_sq2_czb .section}

`stringFormat` formats strings by replacing placeholders with values passed by the user. Formatting options \(e.g. field width, precision, alignment\) can be specified for more precise control over how the values are formatted in the output strings.

Table 1. Supported data types

|Type|Placeholder \(%-formatting\)|Examples of args|
|----|----------------------------|----------------|
|BOOL|%b|1b, 0b, true, false|
|CHAR|%c|'a', 97c|
|SHORT|%h|122h|
|integer \(INT\)|%i|21|
|octal|%o|31|
|hexadecimal \(lowercase\)|%x|2f|
|hexadecimal \(uppercase\)|%X|2F|
|LONG|%l|25l|
|DATE|%d|2022.01.01|
|MONTH|%M|2022.05M|
|TIME|%t|13:00:10.706|
|MINUTE|%m|13:30m|
|SECOND|%s|13:30:10|
|DATETIME|%D|2012.06.13 13:30:10, 2012.06.13T13:30:10|
|TIMESTAMP|%T|2012.06.13 13:30:10.008, 2012.06.13T13:30:10.008|
|NANOTIME|%n|13:30:10.008007006|
|NANOTIMESTAMP|%N|2012.06.13 13:30:10.008007006, 2012.06.13T13:30:10.008007006|
|FLOAT|%f|2.1f|
|DOUBLE|%F|2.1|
|SYMBOL|%S|symbol\(\["aaa", "bbb"\]\)|
|STRING|%W|"Hello"|
|ANY \(tuple\)|%A|\(1, 45, 'sah'\)|

**Note:** If the string contains a "%" character, it must be escaped by using a double percent sign \(%%\).

You can specify formatting options inside the placeholders like `%[(var)][#][±][0][m/*][.][n/*]type`.

Table 2. The following table lists the options which can be inserted before the decimal point `.` in placeholders:

<table id="table_klg_nr2_czb"><thead><tr><th align="left">

Specifier

</th><th align="left">

Meaning

</th><th align="left">

Examples

</th></tr></thead><tbody><tr><td align="left">

*m* \(a positive integer\)

</td><td align="left">

\[Used with %f, %F or %W\]For FLOAT \(f\) and DOUBLE \(F\) data types, *m* indicates the minimum total width of the output string.

-   If *m* is smaller than the actual total number of digits in the float number, the full float number is output directly \(rounded to 6 decimal places if needed\).
-   If *m* is greater than the total digits, the output string is padded with leading spaces by default.

For STRING \(W\) data type, *m* indicates the minimum total length of the output string. -   If m is smaller than the actual string length, the full string is output.
-   If m is greater than the string length, the output string is padded with leading spaces.The output string is right-alignment by default.

</td><td align="left">

`stringFormat("%10f", pi)`output: `··3.141593`

 `stringFormat("%2f", 12345.0)`output: `12345.000000`

`stringFormat("%10W", "6chars")`output: `····6chars`

</td></tr><tr><td align="left">

\*

</td><td align="left">

Like *m*, \* indicates the minimum total width of the output string. However, \* allows passing the width as an argument \(*args*\). Specify the width in the corresponding argument \(*args*\) in tuple format: `(width,value)`.

</td><td align="left">

`stringFormat("%*f", (10,pi))`output: `··3.141593`

</td></tr><tr><td align="left">

0

</td><td align="left">

*0* pads numeric values with zeros. For left-aligned fields, the zeros are padded on the right side. If *0* is not specified, the output string is padded with spaces.

</td><td align="left">

`stringFormat("%010f", pi)`output: `003.141593`

</td></tr><tr><td align="left">

-

</td><td align="left">

*-* left-aligns the output string within the specified field width.

</td><td align="left">

`stringFormat("%-10.3f", pi)`output: `3.142`

</td></tr><tr><td align="left">

+

</td><td align="left">

*+* adds a plus sign "`+`" before positive values.

</td><td align="left">

`stringFormat('%+f', pi)`output: `+3.141593`

</td></tr><tr><td align="left">

\(var\)

</td><td align="left">

\[Cannot be used with other specifiers\] \(var\) allows you to format a string using a dictionary, where the dictionary keys act as variables in the string. To specify a key, put it in parentheses after the *%* symbol. The values in the dictionary are substituted into the string where the `%(key)type` placeholders are located.

</td><td align="left">

`employee = {"name":"Lisa Mill", "year":2010} stringFormat("%(name)W joined the company in %(year)i", employee)`output: `Lisa Mill joined the company in 2010``

</td></tr><tr><td align="left">

\#

</td><td align="left">

\[Used with %o, %x or %X\] *\#* adds "0o" before octal values; adds "0x" \(lower case\) or "0X" \(upper case\) before hexadecimal values.

</td><td align="left">

`stringFormat("%#o", 33)`output: `0o41`

`stringFormat("%#X", 33)`output: `0X21`

</td></tr></tbody>
</table>Table 3. The following table lists the options which can be inserted after the decimal point `.` in placeholders \(these options can only be used with **%f, %F** or **%W**\):

<table id="table_xk1_4r2_czb"><thead><tr><th align="left">

Specifier

</th><th align="left">

Meaning

</th><th align="left">

Examples

</th></tr></thead><tbody><tr><td align="left">

*n* \(a positive integer\)

</td><td align="left">

For FLOAT \(f\) and DOUBLE \(F\) data types, *n* specifies the number of digits after the decimal point.-   If *n* is smaller than the number of decimal digits, the float number is rounded to *n* digits.
-   If *n* is greater than the number of decimal digits, zeros are padded to the right.

For STRING \(W\) data type, *n* specifies the string length.-   If *n* is smaller than the actual length of string, the string is truncated to *n* characters.
-   If *n* is greater than the actual length of string, the full string is output without padding.

</td><td align="left">

`stringFormat("%10.5f", pi)`output: `···3.14159`

 `stringFormat('%10.3f' , 3.1)`output: `·····3.100`

`stringFormat("%2.10W", "6chars")`output: `6chars`

</td></tr><tr><td align="left">

\*

</td><td align="left">

Like *n*, \* specifies the number of digits after the decimal point. However, \* allows specifying the number of decimals \(precision\) by passing it as an argument \(*args*\).Specify the digits in the corresponding argument in tuple format: `([width],[precision],value)`.

</td><td align="left">

Specify precision: `stringFormat("%.*f", (5,pi))`output: `3.14159`

Specify both the minimum field width and the precision: `stringFormat("%0*.*f", (10,5,pi))`output: `···3.14159`

</td></tr></tbody>
</table>## Examples {#section_grm_4r2_czb .section}

``` {#codeblock_ngc_pr2_czb}
stringFormat("date: %d, time: %t", 2022.12.01, 10:12:45.065)
// output: date: 2022.12.01, time: 10:12:45.065

stringFormat("Students account for %i%% of our customers.", 50)
// output: Students account for 50% of our customers.

t = datetime(now())
stringFormat("The current time is %D.", t)
// output: The current time is 2023.01.02T20:36:03.

a = 7.596
stringFormat("%-+10.5f", a)
// output: +7.59600

stringFormat("%010.3f", a) 
// output: 000007.596

product = {"item":"Eggs", "price_per_unit":2}
stringFormat("%(item)W: $ %(price_per_unit)i", product)
// output: Eggs: $ 2
```

**Parent topic:**[Functions](../../Functions/category.md)

