# stretch {#stretch}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`stretch(X, n)`

## Arguments {#arguments}

**X** is a vector/tuple/matrix/table.

**n** is a non-negative integer.

## Details {#details}

-   If *X* is a vector or tuple, stretches *X* evenly to a new vector or tuple with the length of *n*.

-   If *X* is a matrix or table, stretches *X* evenly to a new matrix or table with *n* rows.


The difference between `stretch` and [take](../t/take.md) lies in:

-   `take` takes *n* values iteratively and sequentially from a vector, whereas `stretch` copies each element of the vector to stretch the vector to a new length *n*.


## Examples {#examples}

```
X = 1 NULL 2 3
print stretch(X, 10)
// output: [1,1,1,,,,2,2,3,3]

print stretch(X, 11)
// output: [1,1,1,,,,2,2,2,3,3]

print stretch(X, 12)
// output: [1,1,1,,,,2,2,2,3,3,3]

print take(X, 10)
// output: [1,,2,3,1,,2,3,1,]

Y=array(INT[], 0, 10).append!([1 NULL 3, 4 5, 6 NULL 8, 9 10]);
print stretch(Y,7)
// output: [[1,,3],[1,,3],[4,5],[4,5],[6,,8],[6,,8],[9,10]]

s=[1 2 3, 4 5 6]
stretch(s, 5)
// output: ([1,2,3],[1,2,3],[1,2,3],[4,5,6],[4,5,6])

m=matrix(1 2 3, 4 5 6)
stretch(m,5)
/* output:
col1        col2
1   4
1   4
2   5
2   5
3   6
*/

t=table(1 2 3 as a, 4 5 6 as b)
stretch(t,5)
/* output:
a   b
1   4
1   4
2   5
2   5
3   6
*/
```

