# stopTimerEngine {#stopTimerEngine}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`stopTimerEngine(engine)`

## Arguments {#arguments}

**engine** A STRING scalar representing the engine name. You can provide either the fully qualified name \(e.g., "catalog\_name.orca\_engine.engine\_name"\), or just the engine name \(e.g., "engine\_name"\) when the system will automatically complete it to the corresponding fully qualified name based on the current catalog setting.

## Details {#details}

This function can only be called via `useOrcaStreamEngine` and stops execution of jobs submitted by `DStream::timerEngine`.

## Examples {#examples}

Submit the job:

``` {#codeblock_cbz_tdv_mgc}
if (!existsCatalog("test")) {
	createCatalog("test")	
}
go
use catalog test

// Define the job
def myFunc(x,y,z){
    writeLog(x,y,z)
}

// Define the parameter
a = "aaa"
b = "bbb"
c = "ccc"

// Submit the steam graph
g = createStreamGraph("timerEngineDemo")
g.source("trade", `id`price, [INT, DOUBLE])
 .timerEngine(3, myFunc, a, b, c)
 .setEngineName("myJob")
 .sink("result")
g.submit()
```

Stop job execution:

``` {#codeblock_pvf_vdv_mgc}
useOrcaStreamEngine("myJob", stopTimerEngine)
```

Resume job execution:

``` {#codeblock_dbz_tdv_mgc}
useOrcaStreamEngine("myJob", resumeTimerEngine)
```

**Related functions:**[DStream::timerEngine](../d/DStream_timerEngine.md), [resumeTimerEngine](../r/resumeTimerEngine.md)

