# stopStreamGraph {#stopStreamGraph}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`stopStreamGraph(name)`

## Arguments {#arguments}

**name** is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_graph.graph\_name", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Details {#details}

Suspend the specified stream graph. After successful execution, the stream graph status will be set to stopped.

You can check the status through `getStreamGraphMeta`.

**Return value**: None

## Examples {#examples}

``` {#codeblock_hgp_xgp_mgc}
if (!existsCatalog("orca")) {
	createCatalog("orca")
}
go

use catalog orca

def callTimes(mutable call, mutable tempTable, msg) {
    call += 1
    price = [call]
    volume = [call]
    t = table(price, volume)
    tempTable.append!(t)
    return t
}
name = "UDF"
g = createStreamGraph(name)
ckptConfig = {
    "enable":true,
    "interval": 10000,
    "timeout": 36000,
    "maxConcurrentCheckpoints": 1
};

g.source("trade", `price`volume, [INT,INT])
 .udfEngine(callTimes,["price", "volume"], [`cnt, `tmpTable], [433, table(128:0, ["price","volume"], [INT, INT])])
 .setEngineName("udf")
 .sink("output")
g.submit(ckptConfig)
go
getStreamGraphMeta()
stopStreamGraph("UDF")
startStreamGraph("UDF") 
```

**Related functions:** [createStreamGraph](../c/createStreamGraph.md), [startStreamGraph](startStreamGraph.md)

