# stopHeapSample {#stopHeapSample}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`stopHeapSample()`

## Details {#details}

This function dynamically disables heap memory sampling. Only administrators can execute this function.

## Arguments {#arguments}

None.

## Examples {#examples}

Recommended workflow for memory usage analysis:

1.  Enable heap memory sampling: This can be done by setting the environment variable TCMALLOC\_SAMPLE\_PARAMETER to a value between 1 and 524288 \(recommended: 524288\) before starting DolphinDB; or by dynamically enabling it using `startHeapSample`.
2.  Execute `dumpHeapSample` before and after operations that may cause memory leaks, saving to two different files. Compare these files to confirm memory allocation and usage related to the operation.
3.  Disable heap memory sampling.

``` {#codeblock_zpp_g1c_bdc}
startHeapSample(524288)

dumpHeapSample("/DolphinDB/Data/heap1")
dumpHeapSample("/DolphinDB/Data/heap2")

stopHeapSample()
```

Related functions: [dumpHeapSample](../d/dumpHeapSample.md), [startHeapSample](startHeapSample.md)

