# std {#std}

## Syntax {#syntax}

`std(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

If *X* is a vector, return the \(unbiased\) sample standard deviation of *X*.

If *X* is a matrix, calculate the \(unbiased\) sample standard deviation of each column of *X* and return a vector.

If *X* is a table, calculate the \(unbiased\) sample standard deviation of each column of *X* and return a table.

As with all aggregate functions, null values are not included in the calculation.

**Note:** The result is sample standard deviation instead of population standard deviation.

## Examples {#examples}

```
std(1 2 3);
// output: 1

m=matrix(1 3 5 7 9, 1 4 7 10 13);
m;
```

|\#0|\#1|
|---|---|
|1|1|
|3|4|
|5|7|
|7|10|
|9|13|

```
std(m);
// output: [3.162277660168379,4.743416490252569]
```

