# startHeapSample {#startHeapSample}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`startHeapSample(sampleParameter)`

## Details {#details}

This function dynamically enables heap memory sampling. It sets the TCMALLOC\_SAMPLE\_PARAMETER environment variable, allowing developers to monitor and analyze the program's memory usage. Only administrators can execute this function.

## Arguments {#arguments}

**sampleParameter** is a LONG integer ranging from 1 to 524,288, indicating the approximate gap between sampling actions in bytes. The system takes one sample approximately once every *sampleParmeter* bytes of allocation. A reasonable value is 524288.

## Examples {#examples}

Recommended workflow for memory usage analysis:

1.  Enable heap memory sampling: This can be done by setting the environment variable TCMALLOC\_SAMPLE\_PARAMETER to a value between 1 and 524288 \(recommended: 524288\) before starting DolphinDB; or by dynamically enabling it using `startHeapSample`.
2.  Execute `dumpHeapSample` before and after operations that may cause memory leaks, saving to two different files. Compare these files to confirm memory allocation and usage related to the operation.
3.  Disable heap memory sampling.

``` {#codeblock_oz1_4zb_bdc}
startHeapSample(524288)

dumpHeapSample("/DolphinDB/Data/heap1")
dumpHeapSample("/DolphinDB/Data/heap2")

stopHeapSample()
```

Related functions: [dumpHeapSample](../d/dumpHeapSample.md), [stopHeapSample](stopHeapSample.md)

