# sqlDelete {#sqldelete}

## Syntax {#syntax}

`sqlDelete(table, [where], [from])`

## Arguments {#arguments}

**table** can be an in-memory table or a DFS table.

**where** \(optional\) is a metacode indicating the where condition.

**from** \(optional\) is metacode indicating the from clause, which supports specifying table joins using `ej` or `lj`.

## Details {#details}

Dynamically generate a metacode of the SQL delete statement. To execute the generated metacode, please use function [eval](../e/eval.md).

## Examples {#examples}

Example 1. Delete the records in an in-memory table

```
t1=table(`A`B`C as symbol, 10 20 30 as x)
sqlDelete(t1, <symbol=`C>).eval()
t1;
```

|symbol|x|
|------|---|
|A|10|
|B|20|

Example 2. Delete the records in a DFS table

```
if(existsDatabase("dfs://db1")){
    dropDatabase("dfs://db1")
}

n=1000000
t=table(take(`A`B`C`D,n) as symbol, rand(10.0, n) as value)
db = database("dfs://db1", VALUE, `A`B`C`D)
Trades = db.createPartitionedTable(t, "Trades", "symbol")
Trades.append!(t)
select count(*) from Trades;

// output: 1000000

Trades=loadTable("dfs://db1", "Trades")
sqlDelete(Trades, <symbol=`A>).eval()
select count(*) from Trades;

// output: 750000
```

Example 3. Delete records using table joins. The following example deletes records from t2 that have a matching id in both t1 and t2, where the flag in t1 is equal to 1.

``` {#codeblock_ayh_m5j_zbc}
t1 = table(1..5 as id, [1,2,2,1,1] as flag)
t2 = table(3..7 as id, [100,200,100,150,100] as profit)
sqlDelete(table=t2, where=<flag=1>, from=<ej(t2,t1,`id)>).eval()
t2
```

|id|profit|
|:---|:-----|
|3|100|
|6|150|
|7|100|

