# spline {#spline}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`spline(X, Y, resampleRule, [closed='left'], [origin='start_day'], [outputX=false])`

## Arguments {#arguments}

**X** is a strictly increasing vector of temporal type.

**Y** is a numeric vector of the same length as *X*.

**resampleRule** is a string. See the parameter *rule* of function [resample](../r/resample.md) for the optional values.

**closed** and **origin** \(optional\) are the same as the parameters *closed* and *origin* of function [resample](../r/resample.md).

**outputX** \(optional\) is a Boolean value indicating whether to output the resampled *X*. The default value is false.

## Details {#details}

Resample *X* based on the specified *resampleRule*, *closed* and *origin*. Perform cubic spline interpolation on *Y* based on the resampled *X*.

If *outputX* is unspecified, return a vector of *Y* after the interpolation.

If *outputX*=true, return a tuple where the first element is the vector of resampled *X* and the second element is a vector of *Y* after the interpolation.

## Examples {#examples}

```
spline([2016.02.14 00:00:00, 2016.02.15 00:00:00, 2016.02.16 00:00:00], [1.0, 2.0, 4.0], resampleRule=`60min);

// output: [1,1.0313,1.0626,1.0942,1.1262,1.1585,1.1914,1.225,1.2593,1.2944,1.3306,1.3678,1.4062,1.446,1.4871,1.5298,1.5741,1.6201,1.668,1.7178
,1.7697,1.8237,1.8801,1.9388,2,2.0638,2.1301,2.1987,2.2697,2.3428,2.418,2.4951,2.5741,2.6548,2.7371,2.821,2.9062,2.9928,3.0806,3.1694
,3.2593,3.35,3.4414,3.5335,3.6262,3.7192,3.8126,3.9063,4]
```

