# sma {#sma}

## Syntax {#syntax}

`sma(X, window)`

Please see [TALib](../Themes/TALib.md) for the parameters and windowing logic.

## Details {#details}

Calculate the Simple Moving Average \(sma\) for *X* in a sliding window of the given length.

The formula is: ![](../../images/sma.png)

## Examples {#examples}

```
x=12.1 12.2 12.6 12.8 11.9 11.6 11.2
sma(x,3);
// output: [,,12.299999999999998,12.533333333333331,12.433333333333331,12.099999999999999,11.566666666666664]

x=matrix(12.1 12.2 12.6 12.8 11.9 11.6 11.2, 14 15 18 19 21 12 10)
sma(x,3);
```

|col1|col2|
|----|----|
|||
|||
|12.3|15.6667|
|12.5333|17.3333|
|12.4333|19.3333|
|12.1|17.3333|
|11.5667|14.3333|

Related functions: [wma](../w/wma.md), [trima](../t/trima.md)

