# slice {#slice}

## Syntax {#section_lrw_km2_czb .section}

`slice(obj, index)`

or

`slice(obj, rowIndex, [colIndex])`

which is equivalent to

`obj[index]` or `obj[rowIndex, colIndex]`

## Arguments {#section_ewk_lm2_czb .section}

**obj** can be an array vector,a matrix or a table.

**index**, **rowIndex** and **colIndex** can be scalar/vector/pair indicating the row or column index. If *index*, *rowIndex* or *colIndex* is a pair, it indicates the range of index which is left-closed and right-open.

## Details {#section_mt1_mm2_czb .section}

For `slice(obj, index)`:

-   If *obj* is an array vector and

    -   *index* is a scalar, it returns a vector indicating a column;

    -   *index* is a vector, it returns an array vector of selected rows;

    -   *index* is a pair, it returns an array vector of selected columns.

-   If *obj* is a matrix and

    -   *index* is a scalar, it returns a vector indicating a column.

    -   *index* is a vector or a pair, it returns a matrix of selected columns.

-   If obj is a table and

    -   *index* is a scalar, it returns a dictionary indicating a row.

    -   *index* is a vector or a pair, it returns a table of selected rows.


For `slice(obj, rowIndex, [colIndex])`:

-   If *obj* is an array vector and

    -   *rowIndex* and *colIndex* are both scalars, it returns a vector indicating a column;

    -   *rowIndex* is a scalar and *colIndex* is a pair \(or vise versa\), it returns an array vector of selected rows and columns;

    -   *rowIndex* and *colIndex* are both pair, it returns an array vector of selected rows and columns.

-   If *obj* is a matrix and

    -   *rowIndex* and *colIndex* are both scalars, it returns a scalar indicating the value of specified element of the matrix.

    -   *rowIndex* is a scalar and *colIndex* is a pair \(or vise versa\), it returns a submatrix of selected rows and columns.

    -   *rowIndex* and *colIndex* are both vectors or pairs, it returns a submatrix of selected rows and columns.

-   If *obj* is a table and

    -   *rowIndex* and *colIndex* are both scalars, return a scalar indicating the value of specified element of the table.

    -   *rowIndex* is a scalar and *colIndex* is a pair \(or vise versa\), it returns a table of selected rows and columns.

    -   *rowIndex* and *colIndex* are both vectors or pairs, it returns a table of selected rows and columns.


**Note:**

-   To get a particular row or column from a table, consider using function `col` or `row`.

-   When *index*, *rowIndex* or *colIndex* specifies the index range of an array vector ora matrix, if the values are not within \[0, size\(X\)-1\], the corresponding results are null values.


## Examples {#section_d4l_nm2_czb .section}

If *obj* is a matrix:

``` {#codeblock_vx1_5m2_czb}
m=1..9$3:3
m.slice(0);
// output: [1,2,3]
    
m.slice([0]);
```

|\#0|
|---|
|1|
|2|
|3|

``` {#codeblock_xx1_5m2_czb}
m.slice(0:2);
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

``` {#codeblock_zx1_5m2_czb}
m.slice(0 2);
```

|\#0|\#1|
|---|---|
|1|7|
|2|8|
|3|9|

``` {#codeblock_by1_5m2_czb}
m.slice(0,1);
// output: 4

m.slice(0 1,0 1);
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|

``` {#codeblock_dy1_5m2_czb}
m.slice(1:2,1:2);
```

|\#0|
|---|
|5|

If *obj* is a table:

``` {#codeblock_fy1_5m2_czb}
t=table(`A`B`C as sym,2018.01.01..2018.01.03 as date,10 48 5 as val)
t.slice(0);
/* output:
val->10
date->2018.01.01
sym->A
t.slice([0]);
*/
```

|sym|date|val|
|---|----|---|
|A|2018.01.01|10|

``` {#codeblock_hy1_5m2_czb}
t.slice(0 1);
```

|sym|date|val|
|---|----|---|
|A|2018.01.01|10|
|B|2018.01.02|48|

``` {#codeblock_jy1_5m2_czb}
t.slice(0:1);
```

|sym|date|val|
|---|----|---|
|A|2018.01.01|10|

``` {#codeblock_ly1_5m2_czb}
t.slice(0,1);
// output: 2018.01.01
 
t.slice(0 1,0 1);
```

|sym|date|
|---|----|
|A|2018.01.01|
|B|2018.01.02|

``` {#codeblock_ny1_5m2_czb}
t.slice(1:2,1:2);
```

|date|
|----|
|2018.01.02|

If *obj* is an array vector:

``` {#codeblock_zrv_5m2_czb}
av =array(DOUBLE[], 0, 10).append!([1.0, 2.1 4.1 6.8, 0.5 2.2 2]);
av[1] 
// output: [,4.1,2.2]

av[1,1]
// output: [4.1]

av[1:3,1:3] 
// output: [[4.1,6.8],[2.2,2]]
```

**Parent topic:**[Functions](../../Functions/category.md)

