# skew {#skew}

## Syntax {#syntax}

`skew(X, [biased=true])`

## Arguments {#arguments}

**X** is a vector/matrix.

**biased** \(optional\) is a Boolean value indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

## Details {#details}

Return the skewness of *X*. The calculation skips null values.

The calculation uses the following formulas in different cases:

-   When *biased*=true:

    ![](../../images/rowskewx.png)

-   When *biased*=false:

    ![](../../images/rowskewfalse.png)


If *X* is a matrix, calculate the skewness of each column of *X* and return a vector.

If *X* is a table, calculate the skewness of each column of *X* and return a table.

The `skew` function also supports querying partitioned tables and distributed tables with bias correction.

## Examples {#examples}

Please note that as the example below uses a random number generator, the result is slightly different each time it is executed.

```
x=norm(0, 1, 1000000);
skew(x);
// output: -0.00124

x[0]=100;
skew(x);
// output: 0.983656

m=matrix(1..10, 1 2 3 4 5 6 7 8 9 100);
m;
```

|\#0|\#1|
|---|---|
|1|1|
|2|2|
|3|3|
|4|4|
|5|5|
|6|6|
|7|7|
|8|8|
|9|9|
|10|100|

```
skew(m);
// output: [0,2.630083823883674]
```

