# share {#share}

## Syntax {#syntax}

`share(table, sharedName, [database], [dbName], [partitionColumn], [readonly=false])`

## Arguments {#arguments}

**table** is the table or engine to be shared across all sessions.

**sharedName** is a string indicating the name to be used to refer to the shared table across all sessions, or the name of the DFS table to be shared.

**database** \(optional\) is a database handle. When it is defined by the function [database](../d/database.md), it specifies the location of each partition.

**dbName** \(optional\) is a string indicating the distributed database name.

**partitionColumn** \(optional\) is the partitioning column of the DFS table.

**readonly** \(optional\) is a Boolean value indicating whether to share an ordinary/keyed/indexed in-memory table as a readonly table to improve query performance. The default value is false.

## Details {#details}

If only *table* and *sharedName* are specified:

-   When *table* is a table, it is shared across all sessions with the specified shared name. Local objects including tables are invisible to other sessions. They need to be shared before they are visible to other sessions. The shared name must be different from all regular table names on all sessions. Data of a shared stream table cannot be deleted or updated, but data of a shared table \(created with `table` or `mvccTable`\) can be deleted or updated. Data inserts are allowed on all types of shared tables.

-   When *table* is a streaming engine, a lock is applied to the engine to allow concurrent writes.


If all 5 parameters are used: populate a shard of a distributed table and share it across all sessions with a shared name. The sharding is based on the given partitioning column. Multiple `share` statements are used together to save a DFS table on multiple nodes.

The rows of a shared stream table cannot be updated or deleted. In comparison, the rows of other shared tables can be updated or deleted.

Note that it is not allowed to share a stream table multiple times by modifying the shared table name.

## Examples {#examples}

```
share(t, `sharedT);
share(t, `quotes, tickDB, `tickDB, `date);
```

```
trades = streamTable(1:0, `time`sym`price, [TIMESTAMP, SYMBOL, DOUBLE])
share table(100:0, `sym`time`factor1, [SYMBOL, TIMESTAMP, DOUBLE]) as outputTable
engine = createReactiveStateEngine(name="test", metrics=[<time>, <mavg(price, 3)>], dummyTable=trades, outputTable=outputTable, keyColumn=`sym)
// share engine
share(engine, "test")

// define a function write1 to write to the engine
def write1(mutable engine) {
  N = 10
  for (i in 1..500) {
      data = table(take(now(), N) as time, take(`A`B, N) as sym, rand(10.0, N) as price)
      engine.append!(data)
  }
}
// define a function write2 to write to the engine
def write2(mutable engine) {
  N = 10
  for (i in 1..500) {
      data = table(take(now(), N) as time, take(`C`D, N) as sym, rand(10.0, N) as price)
      engine.append!(data)
  }
}
// submit jobs to write to the engine at the same time
submitJob("j1", "j1", write1, engine)
submitJob("j2", "j2", write2, engine)
// the number of output records is 10000, which is exactly the sum of records written by write1 and write2
select count(*) from outputTable
// output: 10,000
```

Related functions: [undef](../u/undef.md), [Undefine Variables](../../Programming/Objects/Variable/UndefineVariables.md)

