# setTableComment {#setTableComment}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`setTableComment(table, comment)`

## Arguments {#arguments}

**table** is a DFS table.

**comment** is a STRING scalar for table comment, limited to 4096 bytes.

## Details {#details}

Add comments to a DFS table. Use function [schema](schema.md) to view table comments.

## Examples {#examples}

``` {#codeblock_gcg_tks_xbc}
// create a DFS table
db = database(directory="dfs://testDB", partitionType=VALUE, partitionScheme=1..5)
schemaTB = table(1..5 as id, take(`A`B`C,5) as sym, rand(10.0,5) as price)
pt = db.createPartitionedTable(table=schemaTB, tableName="pt", partitionColumns="id")
// add comment "my first pt" to table pt
setTableComment(table=pt, comment="my first pt")
// check the comment with function schema
schema(pt)["tableComment"]
// output: 'my first pt'
```

