# setStreamTableFilterColumn {#setstreamtablefiltercolumn}

## Syntax {#syntax}

`setStreamTableFilterColumn(streamTable, columnName)`

## Arguments {#arguments}

**streamTable** is a stream table object.

**columnName** is a string indicating a column name. The column must be of type SYMBOL, STRING or INT.

## Details {#details}

Specify the filtering column of a stream table. It is related to parameter *filter* in function [subscribeTable](subscribeTable.md) The value of parameter *filter* is a vector. Only the rows with values of the filtering column in *filter* are published to the subscriber. A stream table can have only one filtering column.

## Examples {#examples}

In the following example, the filter column of the stream table "trades" is "symbol". The table "trades\_slave" on the same node subscribes to "trades" and the filter is set to \["IBM", "GOOG"\]. Only when the column "symbol" is "IBM" or "GOOG", the corresponding data will be published.

```
share streamTable(10000:0,`time`symbol`price, [TIMESTAMP,SYMBOL,INT]) as trades
setStreamTableFilterColumn(trades, `symbol)
trades_1=table(10000:0,`time`symbol`price, [TIMESTAMP,SYMBOL,INT])

filter=symbol(`IBM`GOOG)

subscribeTable(tableName=`trades, actionName=`trades_1, handler=append!{trades_1}, msgAsTable=true, filter=filter);
```

