# setRaftElectionTick {#setraftelectiontick}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`setRaftElectionTick(groupId, tickCount)`

## Arguments {#arguments}

**groupId** is a positive integer indicating the raft group ID. Currently it can only be 1, referring to the ID of the raft group composed of controllers.

**tickCount** is an integer no less than 800 \(in 10ms\).

## Details {#details}

Use this command to dynamically set the configuration parameter *raftElectionTick*. *tickCount* specifies a time interval: \[*tickCount*, 2\**tickCount*\]. After receiving the last heartbeat from the leader, if a follower does not receive the next heartbeat after a random waiting time within the specified interval, it will send a request for leader election.

**Note:**

-   The command must be executed by the admin on all controllers within a raft group, please make sure that they all share the same *raftElectionTick* value.

-   The command will not modify the configuration parameter *raftElectionTick*. It will restore to the default or specified value after the server restarts.


Related Functions: [getRaftElectionTick](../g/getRaftElectionTick.md), [getControllerElectionTick](../g/getControllerElectionTick.md)

