# setMaxTransactionSize {#setMaxTransactionSize}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`setMaxTransactionSize(engine, maxSizeGB)`

## Arguments {#arguments}

**engine** is a string scalar representing the corresponding storage engine. It can be "TSDB" or "OLAP".

**maxSizeGB** is a numeric scalar representing the maximum size \(in GB\) of a write transaction.

## Details {#details}

Modify the maximum size of a single write transaction \(in GB\) for the current data/compute node online. Note that the transaction size cannot exceed the corresponding cache engine size.

This command can only be executed by an administrator. For more information on DolphinDB memory management configuration parameters and strategies, refer to the [Reference - Memory Management](../../Database/Configuration/reference.md#).

**Notes:**

-   If the OLAP engine does not have the cache engine enabled, this function imposes no limit on write transactions for OLAP.
-   If the cache engine size for the current node has been modified online \(using `[setOLAPCacheEngineSize](setOLAPCacheEngineSize.md)` or `[setTSDBCacheEngineSize](setTSDBCacheEngineSize.md)`\), this function cannot set a value larger than the current cache engine size.
-   The modified configuration will expire after the server is rebooted. To permanently limit write transaction size, adjust *maxTransactionRatio* in the configuration file to control the maximum proportion of the cache engine that a write transaction can occupy.

