# setMaxMemSize {#setmaxmemsize}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`setMaxMemSize(memSizeGB, [emergencyMemSizeGB])`

## Arguments {#arguments}

**memSizeGB** is a numeric scalar \(in GB\). It is greater than 0 but no greater than *maxMemoryPerNode* \(specified by DolphinDB license\), which can be checked with function `license`. Otherwise an error will be raised.

**emergencyMemSizeGB**\(optional\) is a numeric scalar \(in GB\) used to dynamically modify the size of the emergency memory area. It must be greater than 0 and less than 50% *memSizeGB*. It must be at least 256 MB and no more than 5 GB.If not specified, the value remains unchanged from the *[emergencyMemSize](../../Database/Configuration/reference.md#)* configuration parameter.

## Details {#details}

Modify the maximum memory and emergency memory allocated to DolphinDB online. This command can only be executed by the administrator. Call `getClusterPerf().maxMemSize` to check if the modification on maximum memory has taken effect.

When dynamically adjusting the maximum memory space \(the corresponding configuration parameter is *maxMemSize*\), if the user does not specify other settings, the system will automatically adjust the sizes of the reserved memory area \(*reservedMemSize*\) and the emergency memory area \(*emergencyMemSize*\) as follows:

-   *reservedMemSize* will be set to 5% of the provided *memSizeGB*, with a minimum of 64 MB and a maximum of 1 GB.
-   *emergencyMemSize* \(if not explicitly set\) will be set to 5% of *memSizeGB*, with a minimum of 256 MB and a maximum of 5 GB.

For more information on DolphinDB memory management configuration parameters and strategies, refer to the [Reference - Memory Management](../../Database/Configuration/reference.md#).

**Note:**

The modified configuration will expire after the server is rebooted. To make it permanent, please change the configuration parameter *maxMemSize* and *emergencyMemSize* \(see [Memory Management](../../Database/Configuration/reference.md#)\).

