# setIPConnectionLimit {#setIPConnectionLimit}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`setIPConnectionLimit(IP, limit)`

## Arguments {#arguments}

**IP** is a string representing the IP address.

**limit** is a positive integer specifying the connection limit. A value of -1 indicates no limit.

## Details {#details}

Set the maximum number of connections allowed from each IP address to the current node.

This limit applies to API and `xdb` connections but does not affect internal connections between cluster nodes \(e.g., `rpc`\).

This function can only be executed by an administrator on Linux.

## Examples {#examples}

Set the maximum number of connections for IP address "192.168.1.56" to 10:

``` {#codeblock_zq1_tms_c2c}
setIPConnectionLimit("192.168.1.56", 10);
```

Remove the connection limit for IP address "192.168.1.56":

``` {#codeblock_kj3_vcv_fgc}
setIPConnectionLimit("192.168.1.56", -1);
```

Related function: [getIPConnectionLimit](../g/getIPConnectionLimit.md)

