# setDatabaseClusterReplicationExecutionSet {#setDatabaseClusterReplicationExecutionSet}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#topic_ptl_5t2_cbc}

`setDatabaseClusterReplicationExecutionSet(dbHandle, executionSet)`

## Arguments {#topic_b3z_5t2_cbc}

**dbHandle** is the database handle for which to set the execution set.

**executionSet** is an integer 0 or 1, representing the execution set. When asynchronous replication is enabled for the database, the default execution set is 0.

## Details {#topic_xxd_vt2_cbc}

Set the execution set for asynchronous replication tasks of a database. Tasks within an execution set are executed sequentially. Different execution sets are isolated and executed in parallel. This function can only be executed by an administrator on the data nodes of the master cluster for databases that have asynchronous replication enabled.

## Examples {#topic_ayf_vt2_cbc}

``` {#codeblock_k3c_yt2_cbc}
setDatabaseClusterReplicationExecutionSet(dbHandle=database("dfs://test"), executionSet=1)
```

