# setAtomicLevel {#setatomiclevel}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`setAtomicLevel(dbHandle, atomic)`

## Arguments {#arguments}

**dbHandle** is a distributed database handle returned by function [database](../d/database.md).

**atomic** indicates at which level the atomicity is guaranteed for a write transaction, thus determining whether concurrent writes to the same chunk are allowed. It can be 'TRANS' or 'CHUNK' and the default value is 'TRANS'.

-   'TRANS' indicates that the atomicity is guaranteed at the transaction level. If a transaction attempts to write to multiple chunks and one of the chunks is locked by another transaction, a write-write conflict occurs, and all writes of the transaction fail. Therefore, setting *atomic* ='TRANS' means concurrent writes to a chunk are not allowed.

-   'CHUNK' indicates that the atomicity is guaranteed at the chunk level. If a transaction tries to write to multiple chunks and a write-write conflict occurs as a chunk is locked by another transaction, instead of aborting the writes, the transaction will keep writing to the non-locked chunks and keep attempting to write to the chunk in conflict until it is still locked after a few minutes. Therefore, setting *atomic* ='CHUNK' means concurrent writes to a chunk are allowed. As the atomicity at the transaction level is not guaranteed, the write operation may succeed in some chunks but fail in other chunks. Please also note that the write speed may be impacted by the repeated attempts to write to the chunks that are locked.


## Details {#details}

To manually specify at which level concurrent writes are allowed in a distributed database.

## Examples {#examples}

```
dbPath="dfs://test"
mydb=database(dbPath, VALUE, ['AMZN','NFLX', 'NVDA'])
mydb.schema()

/* output:
databaseDir->dfs://test
partitionSchema->[NVDA,AMZN,NFLX]
partitionSites->
partitionTypeName->VALUE
partitionType->1
atomic->TRANS
*/

setAtomicLevel(mydb, `CHUNK)
mydb.schema()

/* output:
databaseDir->dfs://test
partitionSchema->[NVDA,AMZN,NFLX]
partitionSites->
partitionTypeName->VALUE
partitionType->1
atomic->CHUNK
*/
```

