# semiMonthEnd {#semimonthend}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`semiMonthEnd(X, [dayOfMonth=15], [offset], [n=1])`

## Arguments {#arguments}

**X** is a scalar/vector of data type DATE, DATEHOUR, DATETIME, TIMESTAMP or NANOTIMESTAMP.

**dayOfMonth** \(optional\) is an integer between 2 and 27. The default value is 15.

**offset** \(optional\) is a scalar of the same data type as *X*. It must be no greater than the minimum value of *X*. The default value is the minimum value of *X*.

**n** \(optional\) is a positive integer. The default value is 1.

## Details {#details}

Suppose *X* is the d-th day of the month:

-   If d &lt; *dayOfMonth*: return the last day of the previous month.

-   If d &gt;= *dayOfMonth*: return the *dayOfMonth*-th day of the current month.


If parameter *offset* is specified, the result is updated every n semi-months. The parameters *offset* and *n* must be specified together, and *offset* takes effect only when *n* &gt; 1.

## Examples {#examples}

```
semiMonthEnd(2012.06.12);
// output: 012.05.31

semiMonthEnd(2012.06.24);
// output: 012.06.15


semiMonthEnd(2012.06.15);
// output: 012.06.15

semiMonthEnd(2012.06.16, 16);
// output: 012.06.16


date=2016.04.07+(1..10)*7
time = take(09:30:00, 10);
sym = take(`MSFT,10)
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29 52.38
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800 4500
t1 = table(date, time, sym, qty, price);
t1;
```

|date|time|sym|qty|price|
|----|----|---|---|-----|
|2016.04.14|09:30:00|MSFT|2200|49.6|
|2016.04.21|09:30:00|MSFT|1900|29.46|
|2016.04.28|09:30:00|MSFT|2100|29.52|
|2016.05.05|09:30:00|MSFT|3200|30.02|
|2016.05.12|09:30:00|MSFT|6800|174.97|
|2016.05.19|09:30:00|MSFT|5400|175.23|
|2016.05.26|09:30:00|MSFT|1300|50.76|
|2016.06.02|09:30:00|MSFT|2500|50.32|
|2016.06.09|09:30:00|MSFT|8800|51.29|
|2016.06.16|09:30:00|MSFT|4500|52.38|

```
select avg(price),sum(qty) from t1 group by semiMonthEnd(date);
```

|semiMonthEnd\_date|avg\_price|sum\_qty|
|------------------|----------|--------|
|2016.03.31|49.6|2200|
|2016.04.15|29.49|4000|
|2016.04.30|102.495|10000|
|2016.05.15|112.995|6700|
|2016.05.31|50.805|11300|
|2016.06.15|52.38|4500|

