# seek {#seek}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`seek(handle, offset, [mode])`

## Arguments {#arguments}

**handle** must be a file handle.

**offset** is an integer.

**mode** \(optional\) must be one of the 3 positions: HEAD, CURRENT, TAIL. Default mode is CURRENT.

## Details {#details}

Return the final position of the internal cursor if no exception is raised.

When the system reads data from a file or writes data to a file, the internal cursor moves forward. Users can manipulate the cursor manually with the `seek` function.

## Examples {#examples}

```
// write a function to show the length of a file
def fileLength(f): file(f).seek(0, TAIL)
fileLength("test.txt");
// output: 14

// move the internal cursor to the beginning of the file
fin=file("test.txt")
fin.readLine();
// output: Hello World!

fin.seek(0, HEAD);
// output: 0

fin.readLine();
// output: Hello World!
```

