# seasonalEsd {#seasonalesd}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`seasonalEsd(data, period, [hybrid], [maxAnomalies], [alpha])`

## Arguments {#arguments}

**data** is a numeric vector.

**period** is an integer larger than 1 indicating the length of a time-series cycle.

**hybrid** \(optional\) is a Boolean value indicating whether to use median and median absolute deviation to replace mean and standard deviation. The results are more robust if *hybrid*=true. The default value is false.

**maxAnomalies** \(optional\) is a positive integer or a floating number between 0 and 0.5. The default value is 0.1.

-   If *maxAnomalies* is a positive integer, it must be smaller than the size of data. It indicates the upper bound of the number of anomalies.

-   If *maxAnomalies* is a floating number between 0 and 0.5, the upper bound of the number of anomalies is int\(size\(*data*\) \* *maxAnomalies*\).


**alpha** \(optional\) alpha is a positive number indicating the significance level of the statistical test. A larger alpha means a higher likelihood of detecting anomalies.

## Details {#details}

Conduct anomaly detection with the Seasoned Extreme Studentized Deviate test \(S-ESD\).

The result is a table of anomalies. It has 2 columns: column index records the subscript of anomalies in data, and column anoms are the anomaly values.

## Examples {#examples}

```
n = 100
trend = 6 * sin(1..n \ 200)
seasonal = sin(pi / 6 * 1..n)
residual = rand(1.0, n) - 0.5
data = trend + seasonal + residual
data[20 50 70] += 20;

seasonalEsd(data, 12);
```

|index|anoms|
|-----|-----|
|50|22.6365|
|70|21.141346|
|20|19.174165|

