# saveTextFile {#savetextfile}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`saveTextFile(content, filename, [append=false], [lastModified])`

## Arguments {#arguments}

**content** is the contents to be written into the file.

**filename** is a string indicating the absolute path and name of the output file. Currently the output file can only be saved in *.csv* format.

**append** \(optional\) is a Boolean flag. True means appending while false means overwriting.

**lastModified** \(optional\) is the previously modified time displayed in epoch time format.

## Details {#details}

Save strings to a file by appending or overwriting. It must be executed by a logged-in user.

## Examples {#examples}

```
saveTextFile("1234567890\n0987654321\nabcdefghijk\n", "/home/test/abc.txt", false, 1495762562671l);

/* output content of file "/home/test/abc.txt":
1234567890
0987654321
abcdefghijk
*/
```

