# savePartition {#savepartition}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`savePartition(dbHandle, table, tableName, [compression=true])`

## Arguments {#arguments}

**dbHandle** is a DolphinDB database handle.

**table** is the table in memory to be saved.

**tableName** is a string indicating the desired name of the saved partitioned table.

**compression** \(optional\) is a Boolean variable. It sets the compression mode. When it is set to *true*, the table will be saved to disk in compression mode. The default value is *true*.

## Details {#details}

Save a table as a partitioned DFS table. It must be executed by a logged-in user.

An empty table must be created with the function [createPartitionedTable](../c/createPartitionedTable.md).

## Examples {#examples}

```
n=1000000
ID=rand(10, n)
value=rand(1.0, n)
t=table(ID, value);

db=database("dfs://rangedb_Trades", RANGE,  0 5 10)
Trades = db.createPartitionedTable(t, "Trades", "ID");
savePartition(db, t, `Trades)

Trades=loadTable(db, `Trades)
select count(value) from Trades;
// output: 1,000,000
```

In the example above, the database db has two partitions: \[0,5\) and \[5,10\). Table t is saved as a partitioned table *Trades* with the partitioning column of *ID* in database db.

We can append another table to the table *Trades*:

```
n=500000
ID=rand(10, n)
value=rand(1.0, n)
t1=table(ID, value);
savePartition(db, t1, `Trades)
Trades=loadTable(db, `Trades)
select count(value) from Trades;
// output: 1,500,000
```

