# saveModule {#savemodule}

## Syntax {#syntax}

`saveModule(name,[moduleDir],[overwrite=false])`\)

## Arguments {#arguments}

**name** is a string indicating the name of the module.

**moduleDir** \(optional\) is a string indicating the directory where the module files are located.

**overwrite** \(optional\) is a Boolean value indicating whether to overwrite the existing module dom file.

## Details {#details}

Serialize a module \(".dos" file\) to a binary file with a file name extension of ".dom". It must be executed by a logged-in user.

The default value of *moduleDir* is the relative directory "modules" that needs to be created by the user. The system searches the relative directory "modules" in the following order: home directory of the node, the working directory of the node, and the directory with the DolphinDB executable. Please note that in the single node mode, these 3 directory are the same by default.

`saveModule` enhances the confidentiality and the security of the code.

## Examples {#examples}

Assuming the directory "modules" under the node's home directory contains the module files "ta.dos" and "system/log/fileLog.dos", the following example serializes the module files to binary files.

```
saveModule("ta");

saveModule("system::log::fileLog");
```

Related command: [loadModule](../l/loadModule.md)

