# StreamGraph::updateRule {#StreamGraph_updateRule}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`StreamGraph::updateRule(engineName, key, rules)`

## Arguments {#arguments}

**engineName** is a string representing the fully qualified name of the streaming engine, such as `"catalog_name.orca_engine.engine_name"`.

**key** is a scalar of STRING or INT type that specifies the key of rule set to be updated.

**rules** is a tuple of metacode indicating the rules to be updated.

## Details {#details}

This function updates the rule set associated with the specified *key* in the stream graph’s rule engine:

-   If the specified *key*already exists in the rule engine, update the corresponding value with *rules*;
-   If the *key*does not exist in the rule engine, add the *rules*.

The core difference from the `updateRule` interface is:

-   Rule changes executed via `StreamGraph::updateRule` are automatically persisted by the system, ensuring that all committed rule modifications are loaded and remain effective after a service restart.
-   Rule changes made via `updateRule` only exist in memory, and the modifications will be lost after a service restart.

## Examples {#examples}

``` {#codeblock_hgp_xgp_mgc}
createCatalog("demo")
go
use catalog demo

// Set the rule set
x = [1, 2, NULL]
y = [ [ < value > 1 > ], [ < price < 2 >, < price > 6 > ], [ < value*price > 10 > ] ]
ruleSets = dict(x, y)

// Create and submit the stream graph
g = createStreamGraph("updateRuleDemo")
g.source("trades", 1000:0, `sym`value`price`quantity, [INT, DOUBLE, DOUBLE, DOUBLE])
    .ruleEngine(ruleSets=ruleSets, outputColumns=["sym","value","price"], policy="all", ruleSetColumn="sym")
    .setEngineName("myRuleEngine")
    .sink("output")
g.submit()

// Update the rule
g.updateRule("demo.orca_engine.myRuleEngine", 1, [<value>=0>])
```

Related functions: [StreamGraph::deleteRule](StreamGraph_deleteRule.md), [updateRule](../u/updateRule.md)

