# StreamGraph::setConfigMap {#StreamGraph_setConfigMap}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`StreamGraph::setConfigMap(dict)`

## Arguments {#arguments}

**dict** is a dictionary, supporting the following key-value pairs:

|**Key**|**Type**|**Default Value**|**Description**|
|-------|--------|-----------------|---------------|
|subscription.batchSize|INT|0|Sets the *batchSize* parameter for all subscriptions in the stream graph.|
|subscription.throttle|INT|1|Sets the *throttle* parameter for all subscriptions in the stream graph.|
|subscription.timeTrigger|BOOL|false|Enables or disables *timeTrigger* for all subscriptions in the stream graph.|
|subscription.sourceOffset|INT|-3|Sets the *offset* parameter for all stream table subscriptions created by `StreamGraph::source` in the stream graph.|
|privateTable.cacheSize|INT|1000|Sets the *cacheSize* parameter of all private stream tables with persistence enabled.|

## Details {#details}

Used to configure private stream tables and subscriptions within a stream graph.During the stream graph creation process, the system automatically adds private stream tables and subscriptions for data redistribution \(shuffle\). These components do not require manual declaration. To modify the runtime parameters of these auto-generated components, you can pass configuration items via `setConfigMap`.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
if (!existsCatalog("orca")) {
	createCatalog("orca")
}
go
use catalog orca

g = createStreamGraph("orca")
  .setConfigMap({
    "subscription.throttle": 1,
    "privateTable.cacheSize": 1000
  })
```

