# StreamGraph::dropGraph {#StreamGraph_dropGraph}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`StreamGraph::dropGraph([includeTables])`

## Arguments {#arguments}

**includesTables** \(optional\) is a Boolean value, indicating whether to delete user-created stream tables \(e.g., source, sink\) associated with the stream graph when deleting the graph. The default value is false.

## Details {#details}

Destroys the stream graph. After successful execution, the stream graph’s status is set to "destroyed", but the metadata record is not deleted.

-   If *includesTables*=true, the specified stream graph and its user-created stream tables will be deleted. Ensure that these stream tables are not referenced by other stream graphs; use `getStreamTableMeta` to check table references.
-   If false, only the stream graph itself will be deleted, leaving the associated stream tables intact.

In a cluster deployment, this function can only be executed by an administrator or a user who has the COMPUTE\_GROUP\_EXEC permission for the compute group that was used to create the stream graph. In a single-node deployment, permission checks are not required.

## Examples {#examples}

``` {#codeblock_hgp_xgp_mgc}
// Submit stream graph
createCatalog("test")
use catalog test

t = table(1..100 as id, 1..100 as value, take(09:29:00.000..13:00:00.000, 100) as timestamp)
g = createStreamGraph("factor")
baseStream = g.source("snapshot",  1024:0, schema(t).colDefs.name, schema(t).colDefs.typeString)
  .reactiveStateEngine([<cumsum(value)>, <timestamp>])
  .setEngineName("rse")
  .buffer("end")
  
g.submit()

// Delete stream graph
g.dropGraph()
```

Related functions: [dropStreamGraph](https://docs.dolphindb.com/en/Functions/d/dropStreamGraph.html), [createStreamGraph](https://docs.dolphindb.com/en/Functions/c/createStreamGraph.html)

