# StreamGraph::deleteRule {#StreamGraph_deleteRule}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`StreamGraph::deleteRule(engineName, key)`

## Arguments {#arguments}

**engineName** is a string representing the fully qualified name of the streaming engine, such as `"catalog_name.orca_engine.engine_name"`.

**key**is a STRING or INT scalar indicating the key for the rule set to be deleted.

## Details {#details}

This function deletes the rule set associated with the specified *key* in the stream graph’s rule engine.

The core difference from the `updateRule` interface is:

-   Rule changes executed via `StreamGraph::updateRule` are automatically persisted by the system, ensuring that all committed rule modifications are loaded and remain effective after a service restart.
-   Rule changes made via `updateRule` only exist in memory, and the modifications will be lost after a service restart.

## Examples {#examples}

``` {#codeblock_hgp_xgp_mgc}
createCatalog("demo")
go
use catalog demo

// Set the rule set
x = [1, 2, NULL]
y = [ [ < value > 1 > ], [ < price < 2 >, < price > 6 > ], [ < value*price > 10 > ] ]
ruleSets = dict(x, y)

// Create and submit the stream graph
g = createStreamGraph("updateRuleDemo")
g.source("trades", 1000:0, `sym`value`price`quantity, [INT, DOUBLE, DOUBLE, DOUBLE])
    .ruleEngine(ruleSets=ruleSets, outputColumns=["sym","value","price"], policy="all", ruleSetColumn="sym")
    .setEngineName("myRuleEngine")
    .sink("output")
g.submit()

// delete the rule
g.deleteRule("demo.orca_engine.myRuleEngine",1)
```

Related functions: [StreamGraph::updateRule](StreamGraph_updateRule.md), [updateRule](../u/updateRule.md)

