# rowIminLast {#rowiminlast}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rowIminLast(args…)`

## Arguments {#arguments}

Please see [rowFunctions](../Themes/rowFunctions.dita) for the parameters and calculation rules.

## Details {#details}

Return a vector of the same length as the number of rows of the argument. The vector contains the index of the element with the smallest value in *X* in each row. If there are multiple elements with the identical smallest value, return the index of the first element from the right.

## Examples {#examples}

``` {#codeblock_mfd_qk3_d1c}
m=matrix([4.5 2.6 1.5 3.2, 1.5 4.8 5.9 1.7, 4.9 2.0 NULL 5.5])
rowIminLast(m)
// output: [1,2,0,1]

trades = table(10:0,`time`sym`p1`p2`p3`p4`p5`vol1`vol2`vol3`vol4`vol5,[TIMESTAMP,SYMBOL,DOUBLE,DOUBLE,DOUBLE,DOUBLE,DOUBLE,INT,INT,INT,INT,INT])
insert into trades values(2022.01.01T09:00:00, `A, 33.2, 33.8, 33.6, 33.3, 33.1, 200, 180, 180, 220, 200)
insert into trades values(2022.01.01T09:00:00, `A, 33.1, 32.8, 33.2, 34.3, 32.3, 150, 280, 190, 100, 220)
insert into trades values(2022.01.01T09:00:00, `A, 31.2, 32.6, 33.6, 35.3, 34.5, 220, 160, 130, 100, 110)
insert into trades values(2022.01.01T09:00:00, `A, 30.2, 32.5, 33.6, 35.3, 34.1, 200, 180, 150, 140, 120)
insert into trades values(2022.01.01T09:00:00, `A, 33.2, 33.8, 33.6, 33.3, 33.1, 180, 160, 160, 180, 200)

select rowAt(matrix(p1, p2, p3, p4, p5), rowIminLast(vol1, vol2, vol3, vol4, vol5)) as price from trades
/* output:
price
33.6
34.3
35.3
34.1
33.6
*/
```

Related function: [rowlmin](rowImin.md)

