# rowGmd5 {#rowgmd5}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rowGmd5(args...)`

## Arguments {#arguments}

**args**is a array vector/columnar tuple.

## Details {#details}

Create an MD5 hash from each row ofX.

**Return Value:** An INT128 vector of the same length as the number of rows in *args*.

## Examples {#examples}

``` {#codeblock_dkk_vjf_c2c}
xs = array(INT[], 0, 10).append!([1 2 3, 4 5, 6 7 8, 9 10])
rowGmd5(xs)
// output: [2a1dd1e1e59d0a384c26951e316cd7e6,678157bbe4fd35371e047b4cadf9c46a,ff93cd8c0033f2ab93726d48661d1221,10986ac9310ecb2f10c3a5524eb38999]
// The output contains four rows, each representing the MD5 hash of a row in xs. For example,   2a1dd1e1e59d0a384c26951e316cd7e6 is the MD5 hash of [1, 2, 3].

gmd5(1 2 3)
// output: 2a1dd1e1e59d0a384c26951e316cd7e6

rowGmd5(xs, xs)
// output: [50420aa84aa547ebc24dfa3ef8fffa57,de90d6c74c0b99f5656b95563a9a35b7,376579b27ec7c2f6eed7347ef0e5a15b,78bf6752e93cbca5fd1dcc3519fc6c55]
 
ys = [1 2 3, 4 5, 6 7 8, 9 10]
ys.setColumnarTuple!(true)
rowGmd5(xs, ys)
// output: [50420aa84aa547ebc24dfa3ef8fffa57,de90d6c74c0b99f5656b95563a9a35b7,376579b27ec7c2f6eed7347ef0e5a15b,78bf6752e93cbca5fd1dcc3519fc6c55]
```

The output contains four rows, each representing the MD5 hash of a row in xs. For example, 2a1dd1e1e59d0a384c26951e316cd7e6 is the MD5 hash of \[1, 2, 3\].

Related functions: [gmd5](../g/gmd5.md)

