# rowWavg {#rowwavg}

## Syntax {#syntax}

`rowWavg(X, Y)`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Details {#details}

Calculate the weighted average of *X* by row with *Y* as the weights and return a vector with the same number of rows of *X*.

## Examples {#examples}

```
m1=matrix(2 -1 4, 8 3 2, 9 0 1)
m2=matrix(8 11 10, 8 17 4, 14 6 4)
rowWavg(m1, m2)
// output: [6.8667, 1.1765, 2.8889]

m3=matrix(2 NULL 4, 8 NULL 2, 9 NULL NULL)
rowWavg(m3, m2)
// output: [6.8667, , 3.4286]

a= -10 12.3 -10 -8
b= 17.9 9 7.5 -4
c= 5.5 5.5 -7 8

rowWavg(matrix(a, b, c), matrix(b, a, c))
// output: [-24.459, 9.3899, 10.6316, -32]

x=array\(DOUBLE\[\],0, 10\).append!\(\[a, b, c\]\)
y=array\(DOUBLE\[\],0, 10\).append!\(\[b, a, c\]\)
rowWavg\(x, y\)
// output: \[-3.6612, 7.0892, 14.4583\]
```

Related function: [wavg](../w/wavg.md)

