# rowTanimoto {#rowtanimoto}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rowTanimoto(X, Y)`

## Arguments {#arguments}

**X** and **Y** are numeric vectors/array vectors of the same length or matrices with the same dimension. If *X* and *Y* are array vectors, the vectors at the same position in *X* and *Y* must have the same length.

## Details {#details}

If both *X* and *Y* are vectors/matrices, calculate the tanimoto distance between *X* and *Y* by row. If both *X* and *Y* are indexed matrices, calculate the tanimoto distance between rows with the same label. For other rows, return NULL.

For a vector and a matrix, the length of the vector must be the same as the number of columns of the matrix. Calculate the tanimoto distance between the vector and each row of the matrix.

If *X* and *Y* are array vectors, calculate the tanimoto distance between the corresponding rows \(vectors\) in *X* and *Y*, i.e., tanimoto\(X.row\(i\),Y.row\(i\)\).

For a vector and an array vector, calculate the tanimoto distance between the vector and each vector in the array vector. Return NULL when *X* and *Y* are of different lengths.

As with all other aggregate functions, null values are ignored in the calculation.

## Examples {#examples}

```
rowTanimoto(3.6 5.2 6.3, 8.6 4.8 5.5)
// output: [0.4467,0.0064,0.0181]

a=array(INT[],0,10)
a.append!([[1, 8, 9],[15, NULL], [25, 22, 13, 15]])
b=array(INT[],0,10)
b.append!([[11, 18, 6],[5, 9], [5, 2, 3, 1]])
rowTanimoto(a,b)
// output: [0.5,0.5714,0.8309]

s1=indexedSeries(2020.01.01..2020.01.03, 10.4 11.2 9)
s2=indexedSeries(2020.01.01 2020.01.03 2020.01.04, 23.5 31.2 26)
rowTanimoto(s1,s2)
// output: [0.4125,0.5337,0.5526]

m=matrix(23 56 47, 112 94 59)
m1=matrix(11 15 89, 52 41 63)
rowTanimoto(m,m1)
// output: [0.3812,0.4889,0.1839]

m.rename!(2020.01.01..2020.01.03, `A`B)
m.setIndexedMatrix!()
m1.rename!(2020.01.01 2020.01.03 2020.01.04, `A`B)
m1.setIndexedMatrix!()
rowTanimoto(m,m1)
// output: [0.3812,NULL,0.3014,NULL]
```

Related function: [tanimoto](../t/tanimoto.md)

