# rowSkew {#rowskew}

## Syntax {#syntax}

`rowSkew(X, [biased=true])`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Arguments {#arguments}

**biased** \(optional\) is a Boolean value, indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

## Details {#details}

Return the skewness of each row in *X*.

The calculation uses the following formula when *biased*=true:

![](../../images/rowskewx.png)

## Examples {#examples}

```
m = [4.5 2.6 1.5 1.5 4.8, 5.9 4.9 2.0 4.0 6.3, 2 2 2 2 2]
rowSkew(m);
// output: [-0.329206341655613,0.586870565935934,-0.707106781186563,0.595170064139497,-0.350377619697706]

m=matrix([4.5 2.6 1.5, 1.5 4.8 5.9, 4.9 2.0 NULL, 4.3 NULL 3.5]);
rowSkew(m);
// output: [-1.064430070205901,0.577633692366209,0.110780117654846]

t1=table(1..5 as x, 10..6 as y, take(3, 5) as z);
rowSkew(t1);
// output: [0.567316577993729,0.652012117044047,0.707106781186548,0.528004979218188,-0.381801774160629]
```

Related function: [skew](../s/skew.md)

