# rowRank {#rowrank}

## Syntax {#syntax}

`rowRank(X, [ascending=true], [groupNum], [ignoreNA=true], [tiesMethod='min'], [percent=false], [precision])`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Arguments {#arguments}

**X** is a matrix.

**ascending** \(optional\) is a Boolean value indicating whether the sorting is in ascending order. The default value is true \(ascending\).

**groupNum** \(optional\) is a positive integer indicating the number of groups to sort *X* into.

**ignoreNA** \(optional\) is a Boolean value indicating whether null values are ignored.

**tiesMethod** \(optional\) is a string indicating how to rank the group of elements with the same value \(i.e., ties\):

-   'min' : the smallest rank value of the tie values.

-   'max' : the largest rank value of the tie values.

-   'average' : the average of the rank values for all ties.

-   'first': Gives the first found tie value the lowest rank value, and continues with the following rank value for the next tie.


**percent** \(optional\) is a Boolean value, indicating whether to display the returned rankings in percentile form. The default value is false.

**precision** \(optional\) is an integer between \[1, 15\]. If the absolute difference between two values is no greater than 10^\(-precision\), the two values are considered to be equal.

**Note:**

If parameter *precision* is specified, *X* must be numeric, and the *tiesMethod* cannot be specified as 'first'.

## Details {#details}

Conduct the following operation within each row of matrix *X*:

-   Return the position of each element in the sorted vector.
-   If *groupNum* is specified, group the elements into *groupNum* groups and return the group number each element belongs to.
-   If *ignoreNA* =true, null values return NULL.

The result is a matrix with the same shape as *X*.

## Examples {#examples}

```
m=matrix(3 1 2 4 7 6 9 8 5, 9 NULL 2 3 5 6 3 2 8).transpose();
m
```

|\#0|\#1|\#2|\#3|\#4|\#5|\#6|\#7|\#8|
|---|---|---|---|---|---|---|---|---|
|3|1|2|4|7|6|9|8|5|
|9||2|3|5|6|3|2|8|

```
m.rowRank();
```

|\#0|\#1|\#2|\#3|\#4|\#5|\#6|\#7|\#8|
|---|---|---|---|---|---|---|---|---|
|2|0|1|3|6|5|8|7|4|
|7||0|2|4|5|2|0|6|

```
m.rowRank(false);
```

|\#0|\#1|\#2|\#3|\#4|\#5|\#6|\#7|\#8|
|---|---|---|---|---|---|---|---|---|
|6|8|7|5|2|3|0|1|4|
|0||6|4|3|2|4|6|1|

```
m.rowRank(groupNum=3);
```

|\#0|\#1|\#2|\#3|\#4|\#5|\#6|\#7|\#8|
|---|---|---|---|---|---|---|---|---|
|0|0|0|1|2|1|2|2|1|
|2||0|0|1|1|0|0|2|

```
m.rowRank(ignoreNA=false);
```

|\#0|\#1|\#2|\#3|\#4|\#5|\#6|\#7|\#8|
|---|---|---|---|---|---|---|---|---|
|2|0|1|3|6|5|8|7|4|
|8|0|1|3|5|6|3|1|7|

```
m.rowRank(ignoreNA=false, tiesMethod='max');
```

|\#0|\#1|\#2|\#3|\#4|\#5|\#6|\#7|\#8|
|---|---|---|---|---|---|---|---|---|
|2|0|1|3|6|5|8|7|4|
|8|0|2|4|5|6|4|2|7|

```
m.rowRank(ignoreNA=false, tiesMethod='first');
```

|col1|col2|col3|col4|col5|col6|col7|col8|col9|
|----|----|----|----|----|----|----|----|----|
|2|0|1|3|6|5|8|7|4|
|8|0|1|3|5|6|4|2|7|

Related functions: [rowDenseRank](rowDenseRank.md), [rank](rank.md)

