# rowCumprod {#rowcumprod}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`rowCumprod(X)`

Please see [rowFunctions](../Themes/rowFunctions.md) for the parameters and calculation rules.

## Details {#details}

`rowCumprod` calculates the cumulative products of the elements in each row of X.

## Examples {#examples}

```
m=matrix([4.5 2.6 1.5, 1.5 4.8 5.9, 4.9 2.0 NULL])
rowCumProd(m)
/* output:
col1        col2    col3
4.5 6.75    33.075
2.6 12.48   24.96
1.5 8.85    8.85
*/

a=array(INT[], 0, 10).append!([1 2 3, 4 5, 6 7 8]);
rowCumProd(a)
// output: [[1,3,6],[4,9],[6,13,21]]

tp = [[1.3,2.5,2.3], [4.1,5.3,6.2]]
tp.setColumnarTuple!()
rowCumProd(tp)
// output: [[1.3,3.25,7.475],[4.1,21.73,134.726]]
```

