# row {#row}

## Syntax {#syntax}

`row(obj, index)`

## Arguments {#arguments}

**obj** is a vector/matrix/table.

**index** is an integral scalar or pair.

## Details {#details}

Return one or more rows of a vector/matrix/table.

## Examples {#examples}

```
x=matrix(1 2 3, 4 5 6);
x;
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
row(x,1);
// output: [2,5]

row(x,0);
// output: [1,4]

x.row(2);
// output: [3,6]

a=table(1..3 as x,`IBM`C`AAPL as y);
a
```

|x|y|
|---|---|
|1|IBM|
|2|C|
|3|AAPL|

```
row(a,1);
/* output:
y->C
x->2
*/

row(a,1:3)
```

|x|y|
|---|---|
|2|C|
|3|AAPL|

Related function: [col](../c/col.md)

