# round {#round}

-   **[row](../../Functions/r/row.md)**  


**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`round(X, [precision])`

## Arguments {#arguments}

**X** is a scalar/vector/matrix.

**precision** \(optional\) is an integer indicating the number of digits \(up to 10\) after the decimal point. The default value is 0.

## Details {#details}

Round a number to the specified number of digits after the decimal point with the round half up rule.

In comparison, functions [floor](../f/floor.md) and [ceil](../c/ceil.md) map a number to the largest previous or the smallest following integer, respectively.

## Examples {#examples}

```
round 2.1;
// output: 2

round 2.9;
// output: 3

round -2.1;
// output: -2

round(2.154,2);
// output: 2.15

round(2.156,2);
// output: 2.16

ceil 2.1;
// output: 3

ceil 2.9;
// output: 3

ceil -2.1;
// output: -2

floor 2.1;
// output: 2

floor 2.9;
// output: 2

floor -2.1;
// output: -3

m = 1.1 2.2 3.3 4.4 5.5 6.6 7.7 8.8 9.9 10$2:5;
m;
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|1.1|3.3|5.5|7.7|9.9|
|2.2|4.4|6.6|8.8|10|

```
round m;
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|1|3|6|8|10|
|2|4|7|9|10|

