# ridgeBasic {#ridgebasic}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ridgeBasic(Y, X, [mode=0], [alpha=1.0], [intercept=true], [normalize=false], [maxIter=1000], [tolerance=0.0001], [solver='svd'], [swColName])`

## Details {#details}

Perform Ridge regression.

Minimize the following objective function:

![image-20230626-092438.png](../../images/ridgeBasic.png)

## Arguments {#arguments}

**Y** is a numeric vector indicating the dependent variable.

**X** is a numeric vector/tuple/matrix/table indicating the independent variable.

-   When *X* is a vector/tuple, it must be of the same length as *Y*.

-   When *X* is a matrix/table, the number of rows must be the same as the length of *Y*.


**mode**is an integer indicating the contents in the output. It can be:

-   0 \(default\): a vector of the coefficient estimates.

-   1: a table with coefficient estimates, standard error, t-statistics, and p-values.

-   2: a dictionary with the following keys: ANOVA, RegressionStat, Coefficient, and Residual.


<table id="table_n2f_fcz_21c"><thead><tr><th align="left">

Source of Variance

</th><th align="left">

DF \(degree of freedom\)

</th><th align="left">

SS \(sum of square\)

</th><th align="left">

MS \(mean of square\)

</th><th align="left">

F \(F-score\)

</th><th align="left">

Significance

</th></tr></thead><tbody><tr><td align="left">

Regression

</td><td align="left">

p

</td><td align="left">

sum of squares regression, SSR

</td><td align="left">

regression mean square, MSR=SSR/R

</td><td align="left">

MSR/MSE

</td><td align="left">

p-value

</td></tr><tr><td align="left">

Residual

</td><td align="left">

n-p-1

</td><td align="left">

sum of squares error, SSE

</td><td align="left">

mean square error, MSE=MSE/E

</td><td align="left">



</td><td align="left">



</td></tr><tr><td align="left">

Total

</td><td align="left">

n-1

</td><td align="left">

sum of squares total, SST

</td><td align="left">



</td><td align="left">



</td><td align="left">



</td></tr></tbody>
</table><table id="table_u2f_fcz_21c"><thead><tr><th align="left">

Item

</th><th align="left">

Description

</th></tr></thead><tbody><tr><td align="left">

R2

</td><td align="left">

R-squared

</td></tr><tr><td align="left">

AdjustedR2

</td><td align="left">

The adjusted R-squared corrected based on the degrees of freedom by comparing the sample size to the number of terms in the regression model.

</td></tr><tr><td align="left">

StdError

</td><td align="left">

The residual standard error/deviation corrected based on the degrees of freedom.

</td></tr><tr><td align="left">

Observations

</td><td align="left">

The sample size.

</td></tr></tbody>
</table><table id="table_x2f_fcz_21c"><thead><tr><th align="left">

Item

</th><th align="left">

Description

</th></tr></thead><tbody><tr><td align="left">

factor

</td><td align="left">

Independent variables

</td></tr><tr><td align="left">

beta

</td><td align="left">

Estimated regression coefficients

</td></tr><tr><td align="left">

StdError

</td><td align="left">

Standard error of the regression coefficients

</td></tr><tr><td align="left">

tstat

</td><td align="left">

t statistic, indicating the significance of the regression coefficients

</td></tr></tbody>
</table>Residual: the difference between each predicted value and the actual value.

**alpha**\(optional\) is a floating number representing the constant that multiplies the L1-norm. The default value is 1.0.

**intercept** \(optional\) is a Boolean value indicating whether to include the intercept in the regression. The default value is true.

**normalize** \(optional\) is a Boolean value. If true, the regressors will be normalized before regression by subtracting the mean and dividing by the L2-norm. If *intercept*=false, this parameter will be ignored. The default value is false.

**maxIter** \(optional\) is a positive integer indicating the maximum number of iterations. The default value is 1000.

**tolerance** \(optional\) is a floating number. The iterations stop when the improvement in the objective function value is smaller than tolerance. The default value is 0.0001.

**solver** \(optional\) is a string indicating the solver to use in the computation. It can be either 'svd' or 'cholesky'. It ds is a list of data sources, solver must be 'cholesky'.

**swColName** \(optional\) is a STRING indicating a column name of *ds*. The specified column is used as the sample weight. If it is not specified, the sample weight is treated as 1.

