# revokeStreamingSQL {#revokeStreamingSQL}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`revokeStreamingSQL(queryId)`

## Arguments {#arguments}

**queryId** \(optional\) A STRING scalar representing the ID name for the registered streaming SQL query.

## Details {#details}

Revoke a streaming SQL query registered via `registerStreamingSQL`. Only for the queries registered by the current user.

**Return value**: None.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
t=table(1..10 as id,rand(100,10) as val)
share t as st
declareStreamingSQLTable(st)
registerStreamingSQL("select avg(val) from st","sql_avg") 

// Get the status of streaming SQL query
getStreamingSQLStatus("sql_avg")

// Revoke the streaming SQL query
revokeStreamingSQL("sql_avg")
```

**Related functions:** [declareStreamingSQLTable](../d/declareStreamingSQLTable.md), [getStreamingSQLStatus](../g/getStreamingSQLStatus.md), [registerStreamingSQL](registerStreamingSQL.md)

