# revoke {#revoke}

## Syntax {#syntax}

`revoke(userId|groupId,accessType,[objs])`

## Arguments {#id_ep2_2hh_d2c}

**userId** \| **groupId** is a string indicating a user name or a group name.

**accessType** is the privilege type or memory limit.

**objs** \(optional\) is a STRING scalar/vector indicating the objects that the priviledges specified by *accessType* applies to. "\*" means all objects. When *accessType* is COMPUTE\_GROUP\_EXEC, *objs* must be compute group\(s\).

See the privilege table in [User Access Control](../g/../../Maintenance/UserAccessControl.md) for the values that *accessType* and *objs* can take.

**Note:**

-   When managing privileges for shared tables, stream tables or streaming engines, *objs* must be in the format "tableName@nodeAlias" or "nodeAlias:tableName".
-   When managing privileges for IMOLTP databases and tables, *objs* must be in the format "oltp://database/table@nodeAlias" or "oltp://database@nodeAlias".

## Details {#details}

-   Revokes specified access privileges to a user or a group of users that were previously granted or denied.

-   Removes the memory limit that was previously set for a specific user. It includes the memory limit of a query result \(when *accessType* = QUERY\_RESULT\_MEM\_LIMIT\) and the memory limit of a task group \(when *accessType* = TASK\_GROUP\_MEM\_LIMIT\). The memory limit will be reverted to the default memory limit configured in the system.


Administrators can grant users all privileges \(*accessType*\) through this command, but regular users, after having the relevant OWNER privileges, can only grant the following privileges through this command: TABLE\_READ, TABLE\_WRITE, TABLE\_INSERT, TABLE\_UPDATE, TABLE\_DELETE, DB\_READ, DB\_WRITE, DB\_INSERT, DB\_UPDATE, DB\_DELETE, DBOBJ\_DELETE, DBOBJ\_CREATE and VIEW\_EXEC.

For the types of permissions that can be revoked, see [grant](../g/grant.md).

## Examples {#examples}

Revoke the privilege of the members of the group "production" to read all tables in all databases:

```
revoke(`production, TABLE_READ, "*")
```

Revoke the denial of the privilege of the members of the group "research" to write to the table dfs://db1/t1:

```
revoke(`research, TABLE_WRITE, "dfs://db1/t1")
```

Revoke the privilege of the members of the group "research" to create tables in the databases dfs://db1 and dfs://db2:

```
revoke("research", DBOBJ_CREATE, ["dfs://db1","dfs://db2"])
```

Revoke the denial of the privilege of the user "AlexSmith" to create or delete databases:

```
revoke("AlexSmith", DB_MANAGE)
```

Revoke the privilege of the user "AlexSmith" to execute script:

```
revoke("AlexSmith", SCRIPT_EXEC)
```

Revoke the denial of the privilege of the user "AlexSmith" to test script:

```
revoke("AlexSmith", TEST_EXEC)
```

