# reverse {#reverse}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`reverse(X)`

## Arguments {#arguments}

**X** is a vector/matrix/in-memory table/ordered dictionary.

## Details {#details}

-   If *X* is a vector or matrix, return a new vector or matrix with reverse order of the original vector or matrix.
-   If X is an ​​in-memory table​, return an in-memory table with reverse ​​row order.
-   If *X* is an ​​ordered dictionary, return an ordered dictionary where the ​​key-value pairs are in reverse order.

## Examples {#examples}

```
reverse `hello `world;
// output: [world,hello]

(1..6).reverse();
// output: [6,5,4,3,2,1]

x=1..6$2:3;
x
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

```
reverse(x);
```

|\#0|\#1|\#2|
|---|---|---|
|6|4|2|
|5|3|1|

``` {#codeblock_r1c_4vp_mgc}
t = table(1 2 3 as a, `x`y`z as b)
reverse(t)
```

|a|b|
|---|---|
|3|z|
|2|y|
|1|x|

``` {#codeblock_v1c_4vp_mgc}
d = dict(1 2 3, `x`y`z, true)
reverse(d)

/*
output:
3->z
2->y
1->x
*/
```

